import React, { useEffect, useRef } from 'react';
import Slider from 'react-slick';
import 'slick-carousel/slick/slick.css';
import 'slick-carousel/slick/slick-theme.css';
import Image from 'next/image';


function Tabing() {
  const sliderRef = useRef(null);

  useEffect(() => {
    startAutoSlide();
  }, []);

  const startAutoSlide = () => {
    if (sliderRef.current) {
      sliderRef.current.slickPlay();
    }
  };

  const stopAutoSlide = () => {
    if (sliderRef.current) {
      sliderRef.current.slickPause();
    }
  };

  const settings = {

    dots: true,
    infinite: true,
    speed: 500,
    prevArrow: false,
    nextArrow: false,
    slidesToShow: 5,
    slidesToScroll: 1,
    autoplay: true, // Enable auto sliding
    autoplaySpeed: 2000, // Set the duration between slides (in milliseconds)
    responsive: [
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  };

  return (
    <div className='container-fluid p-0' style={{ overflow: 'hidden' }}>
      <div className='row mt-5'>
        <div className='col-lg-12 col-12 mx-auto text-center mb-1 mt-5'>
          <h3 className='header-title'>Milestones</h3>
        </div>
      </div>

      <section className="timeline-carousel">

        <div className='rowxxx'>
          <div className='col-12'>
            <div className="timeline-carousel__item-wrapper">
              <Slider ref={sliderRef} {...settings}>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/1977.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">1977</span>
                    <span className="month">Company Established</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/1982-1.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">1982</span>
                    <span className="month">Workshop established  in Lahore, Pakistan</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/1982.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">1982</span>
                    <span className="month">Descon Engineering Abu Dhabi, UAE</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/olyan.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">1982</span>
                    <span className="month">JV with Olayan Group <br/> Olayan-Descon Formed</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2000-2.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2000</span>
                    <span className="month">JV with JGC Corporation</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2000-1.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2000</span>
                    <span className="month">JV with Enerflex Ltd, Canada   <br />PDIL formed</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2001.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2001</span>
                    <span className="month">Workshop established in Ruwais, Abu Dhabi</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2002.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2002</span>
                    <span className="month">Workshop established in Yanbu, Saudi Arabia</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2004.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2004</span>
                    <span className="month">Descon Engineering Qatar</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2005.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2005</span>
                    <span className="month">Workshop established in Hamriyah, UAE</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2006.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2006</span>
                    <span className="month">Acquisition of Altern Energy  </span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2007.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  
                  <div className="timeline-carousel__item-inner">
                    <span className="year">2007</span>
                    <span className="month">Workshop established in Karachi, Pakistan</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2008-1.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2008</span>
                    <span className="month">Descon Oxychem</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2008-kuwait.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2008</span>
                    <span className="month">Descon Engineering Kuwait</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2013.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2013</span>
                    <span className="month">Descon Engineering Iraq</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2015.JPG' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2015</span>
                    <span className="month">Descon Engineering Oman</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2018.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2018</span>
                    <span className="month">Investment in PDPS, South Africa</span>
                  </div>
                </div>
                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2020.png' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2020</span>
                    <span className="month">Diversification into the agri sector</span>
                  </div>
                </div>

                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2024-Azarbaijan.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2024</span>
                    <span className="month">Azarbaijan</span>
                  </div>
                </div>

                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2024-JV-With-KBR.jpg' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2024</span>
                    <span className="month">JV With KBR</span>
                  </div>
                </div>

                <div className="timeline-carousel__item">
                  <div className="timeline-carousel__image">
                    <Image src='/assets/timeline/2024-ras.png' className='img-fluid' width={200} height={100} layout='responsive' alt='Milestone' />
                  </div>

                  <div className="timeline-carousel__item-inner">
                    <span className="year">2024</span>
                    <span className="month">Workshop Established In Ras Laffan</span>
                  </div>
                </div>


              </Slider>
            </div>
          </div>
        </div>

      </section>
    </div>
  );
}

export default Tabing;
